(setf *seamless-spreadplots* t)

;DATAVIS.LSP


(defmeth mv-data-object-proto :create-spreadplot-container (&optional style)
"Creates a spreadplot container object. Binds *spreadplot-container* to the object. Returns the object."
  (send *watcher* :write-text "Constructing SpreadPlot Container")
  (let ((object (make-container 
                  :size (send *vista* :spreadplot-sizes) 
                  :free *free-spreadplots*
                  :local-menus *free-spreadplots*
                  :type (if style style (if *seamless-spreadplots* 0 1));1 7
                  :show nil))
        )
    (setf *spreadplot-container* object)
    (defmeth object :close () (send self :hide-window))
    object))

;OVERLAY1

(setf *xy-hotspots* t)

(defmeth vista-graph-overlay-proto :pull-down-menu-spots (menu x y)
  (let* ((graph (slot-value 'graph))
         (vr (send graph :view-rect))
         (cr (send graph :content-rect)))
    (cond 
      (*xy-hotspots*
       (send  self :draw-pull-down-menu 
              (- (first cr) 13) (+ (second cr) -20) 2)
       (when x (send self :draw-pull-down-menu 
                     (- (first cr) -2) (+ (first cr) (fourth cr) 15) 1))
       (when y (send self :draw-pull-down-menu 
                     (- (first cr) 13) (+ (first cr) (fourth cr)  0) 0))
       )
      (t
       (when menu (send  self :draw-pull-down-menu (+ (first vr) (third vr) -13) 4 2))
       ))
    t))


(defmeth vista-graph-overlay-proto :redraw ()
  (let* ((graph (slot-value 'graph))
         (draw-color (send graph :draw-color))
         (color-mode (send self :color-mode))
         (bottom (send self :bottom-tool-bar))
         (cw (send graph :canvas-width))
         (ch (send graph :canvas-height))
         (i 0)
         (topy 3)
         (height 10)
         (gap 2)
         (td (send graph :text-descent))
         (bottom-of-top (- (second (send graph :margin)) 3))
         (top-of-bottom (- (send graph :canvas-height) 18))
         (bottom-margin (- (send graph :canvas-height) 3 
                           (fourth (send graph :margin))))
         )
    (when (not color-mode) (send graph :use-color nil))
    (when (or (not (send self :old-canvas-width));fwy!
              (/= (send self :old-canvas-width) ;fwy!
                  (send graph :canvas-width)));fwy!
          (send self :old-canvas-width (send graph :canvas-width));fwy!
          (send self :lefts nil));fwy!
   ; (when (not (send self :lefts)) (send self :setup-redraw))
    (send self :setup-redraw)
    (unless *seamless-spreadplots*
            (send graph :draw-line 0 0 cw 0)
            (if (and color-mode (send *vista* :background-color))
                (send graph :draw-color 'toolbar-background)
                (send graph :draw-color 'white))
            (send graph :paint-rect 0 0 ;;;;;;;;;;;;;;;;;;;;;;;;;;
                  (send graph :canvas-width) bottom-of-top);;;;;;;
            (send graph :draw-color draw-color)
            (send graph :draw-line 0 bottom-of-top ;;;;;;;;;;;;;;;
                  (send graph :canvas-width) bottom-of-top);;;;;;;
            )
;general buttons used by all plots
;ALL FOLLOWING ON STANDARD MENU
    (unless *seamless-spreadplots*
            (when (send self :plot-help) (send self :draw-button nil i) 
                  (setf i (1+ i)))
            (when (send self :color) 
                  (send self :draw-button (send self :color-mode) i) ;use-color
                  (setf i (1+ i)))
            (when (send self :mouse-mode) (send self :draw-button nil i) 
                  (setf i (1+ i)))
            (when (send self :pop) (send self :draw-button nil i) 
                  (setf i (1+ i)))
            (when (send self :zoom) (send self :draw-button nil i) 
                  (setf i (1+ i)))
            (when (send self :options) (send self :draw-button nil i) 
                  (setf i (1+ i))))
;WHAT ABOUT SWITCH?
    (when (send self :switch) (send self :draw-button nil i) 
          (setf i (1+ i)))
;X AND Y HAVE HOT-SPOTS
    (unless *xy-hotspots*
            (when (send self :new-x) (send self :draw-button nil i) 
                  (setf i (1+ i)))
            (when (send self :new-y) (send self :draw-button nil i) 
                  (setf i (1+ i)))
;WHAT ABOUT Z?
            (when (send self :new-z) (send self :draw-button nil i) 
                  (setf i (1+ i))))
|#
;specific buttons MOVED TO BOTTOM
    (when *seamless-spreadplots* 
          (send self :setup-bottom-bar
                graph color-mode top-of-bottom bottom draw-color))
    (when (send self :box) 
          (send self :draw-button (send graph :show-box) i)
          (setf i (1+ i)))
    (when (send self :iterate) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :random) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :param) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :undo) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :equate) 
          (send self :draw-button (send graph :equate) i)
          (setf i (1+ i)))
    (when (send self :tiles) (send self :draw-button nil i)
          (setf i (1+ i)))
    (when (send self :bins) (send self :draw-button nil i) 
          (setf i (1+ i)))
    (when (send self :smooth) 
          (send self :draw-button (send graph :show-smooth) i)
          (setf i (1+ i)))
    (when (send self :normal) 
          (send self :draw-button (send graph :show-normal) i)
          (setf i (1+ i)))
    (when (send self :density) 
          (send self :draw-button (send graph :show-density) i)
          (setf i (1+ i)))
    (when (send self :connect) (send self :draw-button nil i)
          (setf i (1+ i)))
    
;following buttons appear on bottom bar
    (when (and (not *seamless-spreadplots*) bottom)
          (send self :setup-bottom-bar 
                graph color-mode top-of-bottom bottom draw-color))
   
    (when (send self :bin2) 
          (send self :draw-button nil i :plus-minus nil :bottom t) 
          (setf i (1+ i))
          (send self :draw-button nil i :plus-minus t :bottom t) 
          (setf i (1+ i)))
    (when (send self :curves) 
          (send self :draw-button (send graph :show-density) i :bottom t) 
          (setf i (1+ i)))
    (when (send self :plot) (send self :draw-button nil i :bottom t) 
          (setf i (1+ i)))
    (when (send self :savedata) (send self :draw-button nil i :bottom t) 
          (setf i (1+ i)))
    
    (when *plot-menu-hot-spot*
          (send self :pull-down-menu-spots t (send self :new-x) (send self :new-y)) )
    ))

(defmeth vista-graph-overlay-proto :setup-bottom-bar 
  (graph color-mode top-of-bottom bottom draw-color)
  (if (and color-mode (send *vista* :background-color))
      (send graph :draw-color 'toolbar-background)
      (send graph :draw-color 'white))
  (send graph :paint-rect 0 top-of-bottom 
        (send graph :canvas-width) (send graph :canvas-height))
  (send graph :draw-color draw-color)
  (send graph :draw-line 0 top-of-bottom 
        (send graph :canvas-width) top-of-bottom)
  t)


(defmeth vista-graph-overlay-proto :setup-redraw ()
  (let* ((string-top (combine "Help" "Color" "Mouse" 
                           (if (send self :pop-state) "Put" "Pop") 
                           (if (send self :zoom-state) "Restore" "Zoom")
                              (send self :options)    (send self :switch)  
                           (if *xy-hotspots* (list "X" "Y" "Z" "Box") "Box")
                           "Iter" "Undo" "Equate" "Fill" "NewBins" 
                           "Smooth" "Normal" "Curves" "Connect" "Random" "Param"))
         (short-string-top (list "?" "C" "M" "P!" "Z!" "Opt" "Swt"))    
         (short-string-top (list "Opt" "Swt"))    
         (buttons-top (list (send self :plot-help)  (send self :color)
                            (send self :mouse-mode) (send self :pop)
                            (send self :zoom)     
                            (send self :new-x) 
                            (send self :new-y)      (send self :new-z) 
                            (send self :box)        (send self :iterate)
                            (send self :undo)       (send self :equate) 
                            (send self :tiles)      (send self :bins) 
                            (send self :smooth)     (send self :normal) 
                            (send self :density)    (send self :connect)
                            (send self :random)     (send self :param)))
         
         (top-bar (send self :setup-redraw-button-bar 
                        string-top buttons-top short-string-top 0)) 
         (lefts (first top-bar))
         (strings (second top-bar))
         (num-top-buttons (length (first top-bar)))
         (string-bot (list "" "NewBins" "BinWidth" "Curves" "Plots" "Data" ))
         (short-string-bot (list "" "New" "BW" "Cvs" "Plts" "Data" )) 
         (buttons-bot (list (send self :bins) (send self :bin2) (send self :bin2) 
                            (send self :curves) (send self :plot)
                            (send self :savedata) ))
         (bot-bar (send self :setup-redraw-button-bar string-bot buttons-bot
                        short-string-bot 0)))
    (when (first bot-bar) 
          (setf lefts (combine lefts (first bot-bar)))
          (setf strings (combine strings (second bot-bar))))
    (send self :num-top-buttons (length (first top-bar)))
    (send self :lefts lefts)
    (send self :strings strings)
    (send self :buttons (repeat nil (length strings)))
    (send self :pull-down-menu-spots t (send self :new-x) (send self :new-y)) 
    ))